/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.stockTicker;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.ComputerCraftProxy;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.WiFiParticle;
import com.simibubi.create.content.logistics.stockTicker.LogisticalStockRequestPacket;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperCategoryMenu;
import com.simibubi.create.content.logistics.stockTicker.StockKeeperRequestMenu;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.IntStream;
import me.pepperbell.simplenetworking.C2SPacket;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.nbt.NBTHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3908;
import org.jetbrains.annotations.Nullable;

public class StockTickerBlockEntity
extends StockCheckingBlockEntity
implements IHaveHoveringInformation,
SidedStorageBlockEntity {
    public AbstractComputerBehaviour computerBehaviour;
    protected List<List<BigItemStack>> lastClientsideStockSnapshot;
    protected InventorySummary lastClientsideStockSnapshotAsSummary;
    protected List<BigItemStack> newlyReceivedStockSnapshot;
    protected String previouslyUsedAddress = "";
    protected int activeLinks;
    protected int ticksSinceLastUpdate;
    protected List<class_1799> categories;
    protected Map<UUID, List<Integer>> hiddenCategoriesByPlayer;
    protected SmartInventory receivedPayments = new SmartInventory(27, this, 64, false);

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.computerBehaviour = ComputerCraftProxy.behaviour(this);
        behaviours.add(this.computerBehaviour);
    }

    public StockTickerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.categories = new ArrayList<class_1799>();
        this.hiddenCategoriesByPlayer = new HashMap<UUID, List<Integer>>();
    }

    public void refreshClientStockSnapshot() {
        this.ticksSinceLastUpdate = 0;
        AllPackets.getChannel().sendToServer((C2SPacket)new LogisticalStockRequestPacket(this.field_11867));
    }

    public SmartInventory getReceivedPaymentsHandler() {
        return this.receivedPayments;
    }

    public List<List<BigItemStack>> getClientStockSnapshot() {
        return this.lastClientsideStockSnapshot;
    }

    public InventorySummary getLastClientsideStockSnapshotAsSummary() {
        return this.lastClientsideStockSnapshotAsSummary;
    }

    public int getTicksSinceLastUpdate() {
        return this.ticksSinceLastUpdate;
    }

    @Override
    public boolean broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType type, PackageOrderWithCrafts order, IdentifiedInventory ignoredHandler, String address) {
        boolean result = super.broadcastPackageRequest(type, order, ignoredHandler, address);
        this.previouslyUsedAddress = address;
        this.notifyUpdate();
        return result;
    }

    @Override
    public InventorySummary getRecentSummary() {
        InventorySummary recentSummary = super.getRecentSummary();
        int contributingLinks = recentSummary.contributingLinks;
        if (this.activeLinks != contributingLinks && !this.method_11015()) {
            this.activeLinks = contributingLinks;
            this.sendData();
        }
        return recentSummary;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.method_8608()) {
            if (this.ticksSinceLastUpdate < 100) {
                ++this.ticksSinceLastUpdate;
            }
            return;
        }
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10582("PreviousAddress", this.previouslyUsedAddress);
        tag.method_10566("ReceivedPayments", (class_2520)this.receivedPayments.serializeNBT());
        tag.method_10566("Categories", (class_2520)NBTHelper.writeItemList(this.categories));
        tag.method_10566("HiddenCategories", (class_2520)NBTHelper.writeCompoundList(this.hiddenCategoriesByPlayer.entrySet(), e -> {
            class_2487 c = new class_2487();
            c.method_25927("Id", (UUID)e.getKey());
            c.method_10572("Indices", (List)e.getValue());
            return c;
        }));
        if (clientPacket) {
            tag.method_10569("ActiveLinks", this.activeLinks);
        }
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.previouslyUsedAddress = tag.method_10558("PreviousAddress");
        this.receivedPayments.deserializeNBT(tag.method_10562("ReceivedPayments"));
        this.categories = NBTHelper.readItemList((class_2499)tag.method_10554("Categories", 10));
        this.categories.removeIf(stack -> !stack.method_7960() && !(stack.method_7909() instanceof FilterItem));
        this.hiddenCategoriesByPlayer.clear();
        NBTHelper.iterateCompoundList((class_2499)tag.method_10554("HiddenCategories", 10), c -> this.hiddenCategoriesByPlayer.put(c.method_25926("Id"), IntStream.of(c.method_10561("Indices")).boxed().toList()));
        if (clientPacket) {
            this.activeLinks = tag.method_10550("ActiveLinks");
        }
    }

    public void receiveStockPacket(List<BigItemStack> stacks, boolean endOfTransmission) {
        if (this.newlyReceivedStockSnapshot == null) {
            this.newlyReceivedStockSnapshot = new ArrayList<BigItemStack>();
        }
        this.newlyReceivedStockSnapshot.addAll(stacks);
        if (!endOfTransmission) {
            return;
        }
        this.lastClientsideStockSnapshotAsSummary = new InventorySummary();
        this.lastClientsideStockSnapshot = new ArrayList<List<BigItemStack>>();
        for (BigItemStack bigStack : this.newlyReceivedStockSnapshot) {
            this.lastClientsideStockSnapshotAsSummary.add(bigStack);
        }
        for (class_1799 filter : this.categories) {
            ArrayList<BigItemStack> inCategory = new ArrayList<BigItemStack>();
            if (!filter.method_7960()) {
                FilterItemStack filterItemStack = FilterItemStack.of(filter);
                Iterator<BigItemStack> iterator = this.newlyReceivedStockSnapshot.iterator();
                while (iterator.hasNext()) {
                    BigItemStack bigStack = iterator.next();
                    if (!filterItemStack.test(this.field_11863, bigStack.stack)) continue;
                    inCategory.add(bigStack);
                    iterator.remove();
                }
            }
            this.lastClientsideStockSnapshot.add(inCategory);
        }
        ArrayList<BigItemStack> unsorted = new ArrayList<BigItemStack>(this.newlyReceivedStockSnapshot);
        this.lastClientsideStockSnapshot.add(unsorted);
        this.newlyReceivedStockSnapshot = null;
    }

    public boolean isKeeperPresent() {
        for (int yOffset : Iterate.zeroAndOne) {
            for (class_2350 side : Iterate.horizontalDirections) {
                class_2338 seatPos = this.field_11867.method_10087(yOffset).method_10093(side);
                for (SeatEntity seatEntity : this.field_11863.method_18467(SeatEntity.class, new class_238(seatPos))) {
                    if (!seatEntity.method_5782()) continue;
                    return true;
                }
                if (yOffset != 0 || !AllBlockEntityTypes.HEATER.is(this.field_11863.method_8321(seatPos))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean addToTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (this.receivedPayments.method_5442()) {
            return false;
        }
        if (!this.behaviour.mayAdministrate((class_1657)class_310.method_1551().field_1724)) {
            return false;
        }
        CreateLang.translate("stock_ticker.contains_payments", new Object[0]).style(class_124.field_1068).forGoggles(tooltip);
        InventorySummary summary = new InventorySummary();
        this.receivedPayments.nonEmptyViews().forEach(summary::add);
        for (BigItemStack entry : summary.getStacksByCount()) {
            CreateLang.builder().text(class_2561.method_43471((String)entry.stack.method_7922()).getString() + " x" + entry.count).style(class_124.field_1060).forGoggles(tooltip);
        }
        CreateLang.translate("stock_ticker.click_to_retrieve", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        return true;
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 side) {
        return this.receivedPayments;
    }

    @Override
    public void destroy() {
        ItemHelper.dropContents(this.field_11863, this.field_11867, (Storage<ItemVariant>)this.receivedPayments);
        for (class_1799 filter : this.categories) {
            if (filter.method_7960() || !(filter.method_7909() instanceof FilterItem)) continue;
            class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (class_1799)filter);
        }
        super.destroy();
    }

    public void playEffect() {
        AllSoundEvents.STOCK_LINK.playAt(this.field_11863, (class_2382)this.field_11867, 1.0f, 1.0f, false);
        class_243 vec3 = class_243.method_24953((class_2382)this.field_11867);
        this.field_11863.method_8406((class_2394)new WiFiParticle.Data(), vec3.field_1352, vec3.field_1351, vec3.field_1350, 1.0, 1.0, 1.0);
    }

    public class RequestMenuProvider
    implements class_3908 {
        public class_1703 createMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer) {
            return StockKeeperRequestMenu.create(pContainerId, pPlayerInventory, StockTickerBlockEntity.this);
        }

        public class_2561 method_5476() {
            return class_2561.method_43473();
        }
    }

    public class CategoryMenuProvider
    implements class_3908 {
        public class_1703 createMenu(int pContainerId, class_1661 pPlayerInventory, class_1657 pPlayer) {
            return StockKeeperCategoryMenu.create(pContainerId, pPlayerInventory, StockTickerBlockEntity.this);
        }

        public class_2561 method_5476() {
            return class_2561.method_43473();
        }
    }
}

